<?php

/**
 * This is the model class for table "DziedzinaPracownika".
 *
 * The followings are the available columns in table 'DziedzinaPracownika':
 * @property double $id
 * @property double $idPracownika
 * @property double $idDziedziny
 * @property double $punkty
 */
class DziedzinaPracownika extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return DziedzinaPracownika the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'DziedzinaPracownika';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		return array(
			array('idPracownika, idDziedziny', 'required'),
			array('idPracownika, idDziedziny, punkty', 'numerical'),

			array('id, idPracownika, idDziedziny, punkty', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		return array(
			'idPracownika0'=>array(self::BELONGS_TO, 'Pracownik', 'idPracownika'),
			'idDziedziny0'=>array(self::BELONGS_TO, 'Dziedzina', 'idDziedziny'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id'=>Yii::t('DziedzinaPracownika', 'id'),
			'idPracownika'=>Yii::t('DziedzinaPracownika', 'idPracownika'),
			'idDziedziny'=>Yii::t('DziedzinaPracownika', 'idDziedziny'),
			'punkty'=>Yii::t('DziedzinaPracownika', 'punkty'),
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		$criteria = new CDbCriteria;

		$criteria->compare('id', $this->id);
		$criteria->compare('idPracownika', $this->idPracownika);
		$criteria->compare('idDziedziny', $this->idDziedziny);
		$criteria->compare('punkty', $this->punkty);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	public static function add($workerId, $dziedzinaId, $points)
	{
		$record = self::model()->findByAttributes(array(
			'idPracownika' => $workerId,
			'idDziedziny' => $dziedzinaId
		));
		if (empty($record))
		{
			$record = new DziedzinaPracownika;
			$record->idDziedziny = $dziedzinaId;
			$record->idPracownika = $workerId;
		}
		$record->punkty = (float)$record->punkty + $points;
		$record->save(false);
	}
}